package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecordUtils;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.commune.uploader.registry.RequestRevision;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.util.HostInstant;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author alexm
 */
public class ListArchiveServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ListArchiveServlet.class);

    @Autowired
    private ControlResponseXmlizer controlResponseXmlizer;
    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));

        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);
        RequestRecord record = uploadRegistry.saveRecord(MpfsRequestRecordUtils.consF(
                new MpfsRequest.ListArchive(
                        ApiArgs.getApiVersion(req),
                        ApiArgs.getMulcaId(reqX),
                        ChemodanFile.cons(ApiArgs.getUid(req), "unused", "unused"),
                        ApiArgs.getCallbackUri(req),
                        ApiArgs.getMaxFileSizeO(req),
                        ApiArgs.getYandexCloudRequestId(reqX)),
                RequestRevision.initial(HostInstant.hereAndNow())));

        resp.setContentType("application/xml");

        controlResponseXmlizer.write(resp.getOutputStream(), "list-archive", record);
    }
}
