package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.uploader.status.LoadingStatusManager;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategyType;
import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;

/**
 * @author nshmakov
 */
public class LoadingStatusServlet extends HttpServlet {

    private static final Logger logger = LoggerFactory.getLogger(LoadingStatusServlet.class);

    @Autowired
    private LoadingStatusManager loadingStatusManager;
    @Autowired
    private CoolPingServlet coolPingServlet;
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));

        if (!coolPingServlet.isAvailable()) {
            resp.setStatus(HttpServletResponse.SC_SERVICE_UNAVAILABLE);
            return;
        }

        MapF<LoadingStatusStrategyType, Long> loadingStatus =
                filterBySpecifiedTypes(loadingStatusManager.computeLoadingStatus(), req);
        resp.getOutputStream().write(objectMapper.writeValueAsBytes(loadingStatus));
    }

    // TODO: remove after migration
    private MapF<LoadingStatusStrategyType, Long> filterBySpecifiedTypes(
            MapF<LoadingStatusStrategyType, Long> loadingStatus, HttpServletRequest req)
    {
        String types = req.getParameter("types");
        if (types != null) {
            SetF<LoadingStatusStrategyType> strategyTypes = Cf.set(LoadingStatusStrategyType.fromString(types));
            return loadingStatus.filter((key, value) -> strategyTypes.containsTs(key));
        } else {
            return loadingStatus;
        }
    }

    // for tests only
    public void setCoolPingServlet(CoolPingServlet coolPingServlet) {
        this.coolPingServlet = coolPingServlet;
    }
}
