package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.misc.web.servlet.PingConfigurableServlet;

/**
 * @author metal
 */
public class PingDiskServlet extends PingConfigurableServlet {

    @Autowired
    private CoolPingServlet coolPingServlet;

    @Override
    protected boolean checkCustomCondition() {
        return coolPingServlet.isAvailable();
    }

    @Override
    protected void handleUnavailability(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        // difference only in line "fail /ping"
        // default ping servlet doesn't has such line
        resp.setStatus(HttpServletResponse.SC_BAD_GATEWAY);
        resp.getWriter().write("fail /ping");
    }
}

