package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.uploader.registry.RequestRecordFilter;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.RecordList;
import ru.yandex.chemodan.uploader.registry.record.status.MpfsRequestStatus;
import ru.yandex.commune.uploader.registry.RequestMeta;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.commune.uploader.registry.StatusFieldsNames;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.registry.UploadRequestId;
import ru.yandex.commune.uploader.util.UploaderJson;
import ru.yandex.commune.util.invokeBean.parser.InvocationParsers;
import ru.yandex.misc.ip.Host;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author vavinov
 */
public class QueueStatusServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(QueueStatusServlet.class);
    private static final RequestRecordFilter recordFilter = new RequestRecordFilter();

    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);

        Option<Host> hostname = reqX.getParameterO("host").filter(Cf.String.notEmptyF()).map(Host.parseF());
        Option<String> filter = reqX.getParameterO("filter").filter(Cf.String.notEmptyF());
        CollectionF<MpfsRequestRecord> records = uploadRegistry.findRecordsInProgress(hostname);

        if (filter.isPresent()) {
            records = filterRecords(filter.get(), records);
        }
        records = records.sortedBy(MpfsRequestRecord.metaF().andThen(RequestMeta.createdF));

        resp.setContentType("text/plain");
        PrintWriter w = resp.getWriter();

        Option<String> pathInfoO = reqX.getPathInfoO();
        if (!pathInfoO.isPresent()) {
            final Instant now = new Instant();

            for (Tuple2<ClassX<MpfsRequestStatus>, ListF<MpfsRequestRecord>> t :
                records.groupBy(MpfsRequestRecord.statusF().andThen(ClassX.<MpfsRequestStatus>getClassF())).entries())
            {
                w.println("# " + t.get1().getSimpleName() + ": " + StatusFieldsNames.getStatusFieldsNames().getTs(t.get1()));
                for (RequestRecord record : t.get2()) {
                    w.println(record.toPrettyString(now));
                }
            }

        } else if (pathInfoO.isSome("/v1")) {
            boolean full = reqX.getParameterO("full").isPresent();
            if (full) {
                w.println(UploaderJson.write(new RecordList(records)));
            } else {
                for (RequestRecord record : records) {
                    w.println(record.toPrettyStringV1());
                }
            }

        } else {
            throw new IllegalStateException("Unknown path: " + pathInfoO);
        }

    }

    private CollectionF<MpfsRequestRecord> filterRecords(String filter, CollectionF<MpfsRequestRecord> records) {
        Tuple2<String, ListF<String>> filterInvocation = InvocationParsers.method().parse(filter);
        return recordFilter.invokeFilter(filterInvocation.get1(), Cf.list(records), filterInvocation.get2());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String command = req.getParameter("command");
        Option<UploadRequestId> idO = getIdO(req);

        if ("cancel".equals(command)) {
            if (idO.isPresent()) {
                uploadRegistry.cancelRecord(idO.get());
            } else {
                uploadRegistry.cancelAllRecords(Option.empty());
            }
        } else if ("flush".equals(command)) {
            int flushedCount = !idO.isPresent() ?
                    uploadRegistry.flushAllRecords(Option.empty()) :
                    uploadRegistry.flushRecord(idO.get());
            resp.setContentType("text/plain");
            resp.getWriter().println(flushedCount);
        } else {
            Validate.fail("Unknown command: " + command);
        }
    }

    private Option<UploadRequestId> getIdO(HttpServletRequest req) {
        return Option.ofNullable(req.getPathInfo()).map(p -> StringUtils.substringAfter(p, "/"))
                .map(UploadRequestId::valueOf);
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UploadRequestId id = UploadRequestId.valueOf(req.getParameter("id"));
        uploadRegistry.deleteRecord(id);
    }
}
