package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.uploader.registry.ApiVersion;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.registry.UploadRequestId;
import ru.yandex.commune.uploader.util.UploaderJson;
import ru.yandex.misc.io.IoFunction1V;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.xml.stream.JavolutionXmlWriter;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * http://wiki.yandex-team.ru/Pochta/chemodan/uploader/api
 *
 * @author vavinov
 */
public class RequestStatusServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(RequestStatusServlet.class);

    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;

    @Override
    protected void doDelete(final HttpServletRequest req, final HttpServletResponse resp) throws IOException {
        withRecord(req, resp, new IoFunction1V<MpfsRequestRecord>() {
            public void applyWithException(MpfsRequestRecord record) throws IOException {
                // XXX FIXME
                resp.sendError(HttpStatus.SC_405_METHOD_NOT_ALLOWED);
            }
        });
    }

    @Override
    protected void doGet(final HttpServletRequest req, final HttpServletResponse resp) throws IOException {
        withRecord(req, resp, new IoFunction1V<MpfsRequestRecord>() {
            public void applyWithException(MpfsRequestRecord record) throws IOException {
                if (Option.ofNullable(req.getParameter("as")).equals(Option.of("json"))) {
                    resp.setContentType("application/javascript");
                    resp.getWriter().println(UploaderJson.write(record));

                } else if (record.getRequest().apiVersion.lt(ApiVersion.V_0_2)) {
                    resp.sendError(HttpStatus.SC_422_UNPROCESSABLE_ENTITY,
                            "API version < 0.2 is no longer supported.");

                } else {
                    resp.setContentType("application/xml");

                    XmlWriter xw = new JavolutionXmlWriter(resp.getOutputStream(), false, "\t");
                    record.xmlize(xw);
                    xw.flush();
                    xw.close();
                }
            }
        });
    }

    private void withRecord(HttpServletRequest req, HttpServletResponse resp, Function1V<MpfsRequestRecord> f)
            throws IOException
    {
        UploadRequestId id = UploadRequestId.valueOf(HttpRequestUtils.localUri(req));
        Option<MpfsRequestRecord> record = uploadRegistry.findRecordDirty(id);
        if (!record.isPresent()) {
            resp.setStatus(HttpStatus.SC_410_GONE);
            resp.setContentType("text/plain; charset=utf-8");
            resp.getWriter().println("No task with such id.  It has probably expired.");
        } else {
            f.apply(record.get());
        }
    }
}
