package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecordUtils;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.chemodan.uploader.web.ApiPrivateUrls;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.commune.uploader.registry.RequestRevision;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.util.HostInstant;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author vavinov
 */
public class UploadDeltaUrlServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(UploadUrlServlet.class);

    @Autowired
    private ControlResponseXmlizer controlResponseXmlizer;
    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));

        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);
        RequestRecord record = uploadRegistry.saveRecord(MpfsRequestRecordUtils.consF(
                new MpfsRequest.PatchAtDefault(
                        ApiArgs.getApiVersion(req),
                        ApiArgs.getMulcaId(reqX),
                        reqX.getRequiredParameter(ApiArgs.ORIGINAL_MD5),
                        ApiArgs.getChemodanFile(req),
                        ApiArgs.getCallbackUri(req),
                        ApiArgs.getMaxFileSizeO(req),
                        ApiArgs.getYandexCloudRequestId(reqX)),
                RequestRevision.initial(HostInstant.hereAndNow())));

        resp.setContentType("application/xml");

        String additionalParams = ApiArgs.getWaitCompleteUploadO(req)
                .map(v -> ApiArgs.WAIT_COMPLETE_UPLOAD + "=" + v).getOrElse("");

        controlResponseXmlizer.write(resp.getOutputStream(), "upload", record,
                Cf.map("delta-target", ApiPrivateUrls.PATCH_TARGET), ApiArgs.getUseHttpsO(req), additionalParams,
                Option.empty());
    }
}
