package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.registry.ApiVersion;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecordUtils;
import ru.yandex.chemodan.uploader.registry.record.status.ExifInfo.GeoCoords;
import ru.yandex.chemodan.uploader.services.ServiceFileId;
import ru.yandex.chemodan.uploader.services.ServiceImageInfo;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.commune.uploader.registry.RequestRevision;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.util.HostInstant;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author vavinov
 */
public class UploadFromServiceServlet extends HttpServlet {

    private static final Logger logger = LoggerFactory.getLogger(UploadUrlServlet.class);

    @Autowired
    private ControlResponseXmlizer controlResponseXmlizer;
    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));
        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);
        RequestRecord record = createRecordFromRequest(reqX);
        resp.setContentType("application/xml");
        controlResponseXmlizer.write(resp.getOutputStream(), "upload-from-service", record);
    }

    private RequestRecord createRecordFromRequest(HttpServletRequestX reqX) {
        ChemodanFile file = ApiArgs.getChemodanFile(reqX);
        ChemodanService service = ChemodanService.R.valueOf(reqX.getRequiredParameter(ApiArgs.SOURCE_SERVICE));

        Option<ServiceFileId> serviceFileId;
        Option<ServiceImageInfo> serviceImageInfo;
        if (service.isExternal()) {
            String serviceFileUrl = reqX.getRequiredParameter(ApiArgs.SERVICE_FILE_URL);
            Option<GeoCoords> location = getLocation(reqX);
            Option<Long> createdSeconds = reqX.getParameterO(ApiArgs.CREATED).map(Cf.Long::parse);
            Option<Instant> created = createdSeconds.map(s -> new Instant(s * 1000));
            serviceImageInfo = Option.of(new ServiceImageInfo(location, serviceFileUrl, created));
            serviceFileId = Option.empty();
        } else {
            serviceImageInfo = Option.empty();
            String rawServiceFileId = reqX.getRequiredParameter(ApiArgs.SERVICE_FILE_ID);
            serviceFileId = Option.of(ServiceFileId.valueOf(rawServiceFileId));
        }

        Option<Boolean> disableRetries = ApiArgs.getDisableRetries(reqX);
        Option<Boolean> disableRedirects = ApiArgs.getDisableRedirects(reqX);
        Option<MulcaId> aviaryOriginalMulcaId = service == ChemodanService.AVIARY ? Option.of(ApiArgs.getMulcaId(reqX)) : Option.empty();

        return uploadRegistry.saveRecord(MpfsRequestRecordUtils.consF(
                new MpfsRequest.UploadFromService(
                        ApiArgs.getApiVersionAtLeast(reqX, ApiVersion.V_0_2),
                        service,
                        serviceFileId,
                        file,
                        ApiArgs.getCallbackUri(reqX),
                        disableRetries,
                        disableRedirects,
                        ApiArgs.getMaxFileSizeO(reqX),
                        serviceImageInfo,
                        aviaryOriginalMulcaId,
                        ApiArgs.getYandexCloudRequestId(reqX),
                        ApiArgs.getExcludeOrientation(reqX)),
                RequestRevision.initial(HostInstant.hereAndNow())));
    }

    private Option<GeoCoords> getLocation(HttpServletRequestX reqX) {
        return reqX.getParameterO(ApiArgs.LATITUDE).map(Double::parseDouble).flatMapO(
                latitude -> reqX.getParameterO(ApiArgs.LONGITUDE).map(Double::parseDouble).map(
                        longitude -> new GeoCoords(latitude, longitude)));
    }
}
