package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.internal.Validate;
import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecordUtils;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.chemodan.uploader.web.ApiPrivateUrls;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.commune.uploader.registry.RequestRevision;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.util.HostInstant;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * http://wiki.yandex-team.ru/Pochta/chemodan/uploader/api
 *
 * @author vavinov
 */
public class UploadToServiceUrlServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(UploadToServiceUrlServlet.class);

    @Autowired
    private ControlResponseXmlizer controlResponseXmlizer;
    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));

        ChemodanService service = ChemodanService.R.valueOf(HttpRequestUtils.localUri(req));
        Validate.isTrue(Cf.set(ChemodanService.FOTKI).containsTs(service), "Unsupported service");

        RequestRecord record = uploadRegistry.saveRecord(MpfsRequestRecordUtils.consF(
                new MpfsRequest.UploadToService(
                        ApiArgs.getApiVersion(req),
                        service,
                        ChemodanFile.cons(ApiArgs.getUid(req), "unused", "unused"),
                        Dom4jUtils.createElement("meta"),
                        ApiArgs.getCallbackUri(req),
                        Option.empty(),
                        ApiArgs.getYandexCloudRequestId(HttpServletRequestX.wrap(req))),
                RequestRevision.initial(HostInstant.hereAndNow())));

        resp.setContentType("application/xml");

        controlResponseXmlizer.write(resp.getOutputStream(), "upload", record,
                Cf.map("post-target", ApiPrivateUrls.UPLOAD_TO_SERVICE_TARGET), ApiArgs.getUseHttpsO(req));
    }
}
