package ru.yandex.chemodan.uploader.web.control;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.internal.Validate;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecordUtils;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.chemodan.uploader.web.ApiPrivateUrls;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.commune.uploader.registry.RequestRevision;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.util.HostInstant;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * http://wiki.yandex-team.ru/Pochta/chemodan/uploader/api
 *
 * @author vavinov
 */
public class UploadUrlServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(UploadUrlServlet.class);

    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;
    @Autowired
    private ControlResponseXmlizer controlResponseXmlizer;

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));

        RequestRecord record = saveRecord(req);

        resp.setContentType("application/xml");

        String additionalParams = ApiArgs.getWaitCompleteUploadO(req)
                .map(v -> ApiArgs.WAIT_COMPLETE_UPLOAD + "=" + v).getOrElse("");

        controlResponseXmlizer.write(resp.getOutputStream(), "upload", record,
                Cf.map("post-target", ApiPrivateUrls.UPLOAD_TARGET),
                ApiArgs.getUseHttpsO(req), additionalParams, ApiArgs.getTld(req));
    }

    public RequestRecord saveRecord(HttpServletRequest req) {
        Option<ChemodanService> service = ChemodanService.R.valueOfO(HttpRequestUtils.localUri(req));
        Validate.isTrue(service.isSome(ChemodanService.DISK), "Unknown service");

        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);

        return uploadRegistry.saveRecord(MpfsRequestRecordUtils.consF(
                new MpfsRequest.UploadToDefault(
                        ApiArgs.getApiVersion(req),
                        ApiArgs.getChemodanFile(req),
                        ApiArgs.getCallbackUri(req),
                        ApiArgs.getMaxFileSizeO(req),
                        ApiArgs.getYandexCloudRequestId(reqX),
                        ApiArgs.getUploadMaxSpeedBps(reqX)),
                RequestRevision.initial(HostInstant.hereAndNow())));
    }
}
