package ru.yandex.chemodan.uploader.web.control.sync;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import ru.yandex.chemodan.uploader.registry.record.status.GenerateImageOnePreviewResult;
import ru.yandex.chemodan.uploader.web.exception.HttpClientClosedException;
import ru.yandex.misc.io.OutputStreamOutputStreamSource;
import ru.yandex.misc.io.RuntimeIoException;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author metal
 */
public abstract class AbstractPreviewSyncRequest extends AbstractSyncRequestServlet {

    protected void writeResultToResponse(GenerateImageOnePreviewResult result, HttpServletResponse resp) {
        try {
            resp.setStatus(HttpStatus.SC_200_OK);
            resp.setContentType(result.getPreviewFormat().getContentType());
            resp.setContentLength((int) result.getPreviewFile().length());

            new OutputStreamOutputStreamSource(resp.getOutputStream()).writeFrom(result.getPreviewFile());
        } catch (RuntimeIoException | IOException ex) {
            throw new HttpClientClosedException(ex);
        }
    }
}
