package ru.yandex.chemodan.uploader.web.control.sync;

import java.io.IOException;
import java.io.OutputStreamWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.uploader.registry.record.status.GenerateAlbumPreviewResult;
import ru.yandex.chemodan.uploader.registry.record.status.GenerateImageOnePreviewResult;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.write.JsonWriter;
import ru.yandex.commune.json.write.JsonWriterImpl;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author metal
 */
public class GenerateAlbumPreviewSyncRequest extends AbstractPreviewSyncRequest {

    @Value("${uploader.preview.album.timeout}")
    private Duration generatePreviewTimeout;

    @Override
    protected void handleRequest(HttpServletRequestX reqX, final HttpServletResponse resp) throws IOException {
        final MulcaId mulcaId = ApiArgs.getMulcaId(reqX);
        final String albumName = reqX.getParameterO(ApiArgs.ALBUM_NAME).getOrElse("");
        final String userName = reqX.getParameterO(ApiArgs.USER_NAME).getOrElse("");
        final boolean isDynamicAlbumPreview = ApiArgs.getDynamicAlbumPreview(reqX).getOrElse(false);

        File2.withNewTempDir("album-preview", workingDir -> {
            if (isDynamicAlbumPreview) {
                GenerateImageOnePreviewResult result =
                        processor.generateDynamicAlbumPreview(mulcaId, workingDir, albumName, userName);
                writeResultToResponse(result, resp);
            } else {
                GenerateAlbumPreviewResult result =
                        processor.generateStaticAlbumPreview(mulcaId, workingDir, albumName, userName);
                writeResultToResponse(resp, result.getPreviewMulcaId());
            }
        });
    }

    private void writeResultToResponse(HttpServletResponse resp, MulcaId albumPreviewMulcaId) {
        JsonObject result = new JsonObject(Tuple2List.fromPairs(
                "album-preview-mulca-id", JsonString.valueOf(albumPreviewMulcaId.toSerializedString())));

        resp.setStatus(HttpStatus.SC_200_OK);

        try {
            ServletOutputStream out = resp.getOutputStream();
            JsonWriter jw = new JsonWriterImpl(new OutputStreamWriter(out));
            jw.writeObject(result);
            jw.close();
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    protected Duration getTimeout() {
        return generatePreviewTimeout;
    }
}
