package ru.yandex.chemodan.uploader.web.control.sync;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.uploader.preview.PreviewSizeParameter;
import ru.yandex.chemodan.uploader.registry.record.status.GenerateImageOnePreviewResult;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class GeneratePreviewSyncRequest extends AbstractPreviewSyncRequest {
    @Override
    protected void handleRequest(HttpServletRequestX reqX, final HttpServletResponse resp) throws IOException {
        final MulcaId mulcaId = ApiArgs.getMulcaId(reqX);
        final PreviewSizeParameter size = ApiArgs.getPreviewSize(reqX);
        final boolean crop = reqX.getParameterO(ApiArgs.PREVIEW_CROP).map(Cf.Boolean.parseF()).getOrElse(false);
        final Option<Integer> quality = ApiArgs.getPreviewQuality(reqX);

        File2.withNewTempDir("dyn-preview", new Function1V<File2>() {
            public void apply(File2 dir) {
                GenerateImageOnePreviewResult result = processor.generatePreview(
                        mulcaId, size, crop, dir, quality);

                writeResultToResponse(result, resp);
            }
        });
    }
}
