package ru.yandex.chemodan.uploader.web.control.sync;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.installer.InstallerModifierParams;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.chemodan.util.http.YandexUidCookieParser;
import ru.yandex.chemodan.util.oauth.OauthClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author akirakozov
 */
public class PatchInstallerServlet extends AbstractSyncRequestServlet {
    private static final Logger logger = LoggerFactory.getLogger(PatchInstallerServlet.class);
    private static final String SOURCE_UNKNOWN = "Yandex.Unknown";

    private static final int MAX_SRC_LENGTH = 25;


    @Override
    protected void handleRequest(HttpServletRequestX reqX, HttpServletResponse resp) throws IOException {
        String clientIp = reqX.getHeader(OauthClient.YA_CONSUMER_CLIENT_IP_HEADER);
        String cookie = reqX.getHeader(OauthClient.YA_CLIENT_COOKIE_HEADER);
        String clientHost = reqX.getHeader(OauthClient.YA_CLIENT_HOST);

        boolean autoLogin = reqX
                .getParameterO("autologin")
                .map(Boolean::parseBoolean)
                .getOrElse(true);

        Option<String> yuid = YandexUidCookieParser.parseYandexUidCode(reqX);

        String source = reqX.getNonEmptyParameterO("src").getOrElse(SOURCE_UNKNOWN);
        source = StringUtils.abbreviate(source, MAX_SRC_LENGTH);

        Option<String> openUrlAfterInstall = reqX.getNonEmptyParameterO("open_url_after_install");

        InstallerModifierParams params = InstallerModifierParams.build(yuid, source, openUrlAfterInstall);

        MulcaId mulcaId = ApiArgs.getMulcaId(reqX);

        logger.info("client-ip: {}, client-host: {}", clientIp, clientHost);
        byte[] patchedInstaller = processor.patchInstaller(mulcaId, clientIp, cookie, clientHost, params, autoLogin);

        resp.setContentType("application/x-msdownload");
        resp.setContentLength(patchedInstaller.length);
        resp.getOutputStream().write(patchedInstaller);
        resp.getOutputStream().close();
    }
}
