package ru.yandex.chemodan.uploader.web.control.sync;

import java.io.IOException;
import java.io.OutputStreamWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.uploader.processor.SyncRequestProcessor;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.commune.json.JsonNumber;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.commune.json.write.JsonWriter;
import ru.yandex.commune.json.write.JsonWriterImpl;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class RecalcDigestsServlet extends AbstractSyncRequestServlet {

    @Override
    protected void handleRequest(HttpServletRequestX reqX, HttpServletResponse resp) throws IOException {
        MulcaId mulcaId = ApiArgs.getMulcaId(reqX);
        boolean withWebdav = ApiArgs.getBooleanParam(reqX, ApiArgs.WITH_WEBDAV, false);
        boolean withExif = ApiArgs.getBooleanParam(reqX, ApiArgs.WITH_EXIF, false);
        boolean withVirusCheck = ApiArgs.getBooleanParam(reqX, ApiArgs.WITH_VIRUS_CHECK, false);
        SyncRequestProcessor.DigestsRecalcResult digests
                = processor.recalcDigests(mulcaId, withWebdav, withExif, withVirusCheck);
        writeResponse(resp.getOutputStream(), digests);
    }

    private void writeResponse(ServletOutputStream out, SyncRequestProcessor.DigestsRecalcResult result) {
        JsonWriter jw = new JsonWriterImpl(new OutputStreamWriter(out));

        Tuple2List<String, JsonValue> map = Tuple2List.fromPairs(
                "md5", JsonString.valueOf(result.info.getMd5()),
                "sha256", JsonString.valueOf(result.info.getSha256()),
                "content-length", JsonNumber.valueOf(result.info.getContentLength()));
        if (result.info.getContentType().isPresent()) {
            map = map.plus1("content-type", JsonString.valueOf(result.info.getContentType().get()));
        }
        if (result.mulcaId.isPresent()) {
            map = map.plus1("webdav-digest-mulca-id", JsonString.valueOf(result.mulcaId.get().toSerializedString()));
        }
        if (result.exif.isPresent()) {
            map = map.plus1("extracted-exif-data", new JsonObject(result.exif.get().describe().mapValues(JsonString::valueOf)));
        }
        if (result.antivirus.isPresent()) {
            map = map.plus1("antivirus-results", JsonString.valueOf(result.antivirus.get().xmlName()));
        }
        jw.writeObject(new JsonObject(map));
        jw.close();
    }

}
