package ru.yandex.chemodan.uploader.web.control.sync;

import java.io.IOException;
import java.io.OutputStreamWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.uploader.av.AntivirusResult;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.commune.json.write.JsonWriter;
import ru.yandex.commune.json.write.JsonWriterImpl;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class RecheckVirusesServlet extends AbstractSyncRequestServlet {

    @Override
    protected void handleRequest(HttpServletRequestX reqX, HttpServletResponse resp) throws IOException {
        MulcaId mulcaId = ApiArgs.getMulcaId(reqX);
        AntivirusResult result = processor.checkWithAntivirus(mulcaId);
        writeResponse(resp.getOutputStream(), result);
    }

    private void writeResponse(ServletOutputStream out, AntivirusResult result) {
        JsonWriter jw = new JsonWriterImpl(new OutputStreamWriter(out));
        jw.writeObject(new JsonObject(
                Tuple2List.<String, JsonValue>fromPairs("result", JsonString.valueOf(result.xmlName()))));
        jw.close();
    }


}
