package ru.yandex.chemodan.uploader.web.control.sync;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

import javax.servlet.http.HttpServletResponse;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.uploader.processor.SyncRequestProcessor.ExtractedExifData;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.serialize.JsonParser;
import ru.yandex.commune.json.write.JsonWriter;
import ru.yandex.commune.json.write.JsonWriterImpl;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class RegenerateExifServlet extends AbstractSyncRequestServlet {

    @Override
    protected void handleRequest(HttpServletRequestX reqX, HttpServletResponse resp) throws IOException {
        MulcaId mulcaId = ApiArgs.getMulcaId(reqX);
        ExtractedExifData exifData = processor.extractExifAndUploadToMulca(mulcaId);
        writeResponse(resp.getOutputStream(), exifData);
    }

    static void writeResponse(OutputStream out, ExtractedExifData exifData) {
        JsonWriter jw = new JsonWriterImpl(new OutputStreamWriter(out));

        JsonObject result = new JsonObject(Tuple2List.fromPairs(
                "exif", ((JsonArray) JsonParser.getInstance().parse(exifData.exifInJson)).getArray().get(0),
                "mid", JsonString.valueOf(exifData.mulcaId.toSerializedString())));

        jw.writeObject(result);
        jw.close();
    }

}
