package ru.yandex.chemodan.uploader.web.data;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.bolts.function.Function0;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.http.HttpHeaderNames;

/**
 * TODO: replace with Red Hat yandex-crossdomain-xml-{env} packages
 * @see CrossdomainServlet
 * @author vavinov
 * @author ssytnik
 */
@SuppressWarnings("serial")
public class CrossdomainXmlServlet extends HttpServlet {
    private final String crossdomainFilePath;

    public CrossdomainXmlServlet(String crossdomainFilePath) {
        super();
        this.crossdomainFilePath = crossdomainFilePath;
    }

    private Function0<String> crossdomainFileContentsF = new Function0<String>() {
        public String apply() {
            return new File2(crossdomainFilePath).readText();
        }
    }.memoize();

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        resp.addHeader(HttpHeaderNames.CONNECTION, "close");
        resp.setContentType("application/xml"); // ssytnik: text/xml ?

        Writer writer = resp.getWriter();
        writer.write(crossdomainFileContentsF.apply());
        writer.flush();
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        doPost(req, resp);
    }
}
