package ru.yandex.chemodan.uploader.web.data;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.commune.uploader.registry.RecordNotFoundException;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class DataHttpServlet extends HttpServlet {

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp)
            throws IOException, ServletException
    {
        try {
            super.service(req, resp);
        } catch (RecordNotFoundException e) {
            resp.sendError(HttpStatus.SC_404_NOT_FOUND);
        } catch (Exception e) {
            // handle all uncaught exceptions as 500, a bit more gracefully than empty 500 response
            resp.sendError(HttpStatus.SC_500_INTERNAL_SERVER_ERROR);
        }
    }
}
