package ru.yandex.chemodan.uploader.web.data;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.uploader.office.OfficeUploadManager;
import ru.yandex.chemodan.uploader.office.OfficeUploadResult;
import ru.yandex.chemodan.uploader.web.ApiArgs;
import ru.yandex.commune.uploader.web.data.RangedPutUtils;
import ru.yandex.misc.io.OutputStreamOutputStreamSource;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author akirakozov
 */
public class UploadFromOfficeServlet extends DataHttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(UploadFromOfficeServlet.class);

    @Autowired
    private OfficeUploadManager officeUploadManager;

    @Override
    public void doPost(final HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));

        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);
        try {
            OfficeUploadResult result = startUpload(reqX);
            for (String header : result.headers.keySet()) {
                resp.addHeader(header, result.headers.get(header));
            }
            resp.setStatus(result.statusCode);
            if (StringUtils.isNotEmpty(result.body)) {
                new OutputStreamOutputStreamSource(resp.getOutputStream()).write(result.body);
            }
        } catch (HttpException e) {
            logger.warn(e, e);
            resp.setStatus(e.getStatusCode().getOrElse(HttpStatus.SC_500_INTERNAL_SERVER_ERROR));
        }
    }

    private OfficeUploadResult startUpload(HttpServletRequestX reqX) {
        return officeUploadManager.startUpload(
                    reqX.getParameterO(ApiArgs.RESOURCE_ID).get(),
                    reqX.getParameterO(ApiArgs.ACCESS_TOKEN).get(),
                    reqX.getParameterO(ApiArgs.ACCESS_TOKEN_TTL).getOrElse(""),
                    reqX.getHeaders().toMap(),
                    reqX.getUserAgent(),
                    RangedPutUtils.makePutRequestContext(reqX),
                    ApiArgs.getYandexCloudRequestId(reqX)
            );
    }
}
