package ru.yandex.chemodan.uploader.web.data;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.uploader.registry.StageListenerPoolWithChildren;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.web.UploadTimeoutHolder;
import ru.yandex.chemodan.uploader.web.data.util.UploadServletUtils;
import ru.yandex.commune.uploader.local.file.LocalFileManager;
import ru.yandex.commune.uploader.local.queue.LocalQueuePush;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.registry.UploadRequestId;
import ru.yandex.commune.uploader.util.http.PutResult;
import ru.yandex.commune.uploader.web.data.DiskWritePolicy;
import ru.yandex.commune.uploader.web.data.RangedPutUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.log.mlf.ndc.Ndc;
import ru.yandex.misc.web.servlet.HttpRequestUtils;

/**
 * @author vavinov
 */
public class UploadToServiceTargetServlet extends DataHttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(UploadToServiceTargetServlet.class);

    @Autowired
    private UploadRegistry<MpfsRequestRecord> uploadRegistry;
    @Autowired
    private LocalFileManager localFileManager;
    @Autowired
    private LocalQueuePush localQueuePush;
    @Autowired
    private DiskWritePolicy diskWritePolicy;
    @Autowired
    private StageListenerPoolWithChildren<Record<?>> stageListenerPool;
    @Autowired
    private UploadTimeoutHolder uploadTimeoutHolder;

    private MpfsRequestRecord.UploadToService getRecord(HttpServletRequest req) {
        logger.info(HttpRequestUtils.describeRemoveSensitive(req));
        final UploadRequestId id = UploadRequestId.valueOf(HttpRequestUtils.localUri(req));
        return uploadRegistry.findRecordAssignedToLocalhost(id, MpfsRequestRecord.UploadToService.class);
    }

    @Override
    public void doHead(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        final MpfsRequestRecord.UploadToService record = getRecord(req);

        Ndc.Handle h = Ndc.push(record.meta.id.toString());
        try {
            RangedPutUtils.processHeadAndSendResponse(record.getStatus().userFile.get(), resp);
        } finally {
            h.popSafely();
        }
    }

    @Override
    public void doPut(final HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        final Record<MpfsRequestRecord.UploadToService> record = Record.cons(uploadRegistry, getRecord(req));

        PutResult result = UploadServletUtils.handleAndExecuteAsap(
            record.get(),
            localQueuePush,
            stageListenerPool,
            uploadTimeoutHolder.getUploadTimeout(req),
            () -> RangedPutUtils.processPut(
                    localFileManager, record, RangedPutUtils.makePutRequestContext(req), diskWritePolicy),
            HttpRequestUtils.getUserAgent(req)
        );

        resp.setStatus(result.getStatusCode());
    }
}
