package ru.yandex.chemodan.uploader.web.data.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

import ru.yandex.commune.uploader.web.data.UploadCanceledException;
import ru.yandex.misc.io.InputStreamX;

/**
 * Upload stream that supports application-level cancellation which will result in UploadCanceledException on reads
 *
 * @author bursy
 */
public class CancelableUploadInputStreamX extends InputStreamX {
    private AtomicBoolean canceled;

    public CancelableUploadInputStreamX(InputStream in) {
        super(in);
        this.canceled = new AtomicBoolean(false);
    }

    @Override
    public int read() throws IOException {
        checkIfCanceled();
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        checkIfCanceled();
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        checkIfCanceled();
        return super.skip(n);
    }

    @Override
    public void close() throws IOException {
        cancel();
    }

    public void cancel() {
        canceled.set(true);
    }

    private void checkIfCanceled() {
        if (canceled.get()) {
            throw new UploadCanceledException();
        }
    }
}
