package ru.yandex.chemodan.uploader.web.data.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.uploader.registry.record.Digests;
import ru.yandex.misc.bytes.ByteArrayByteSequence;
import ru.yandex.misc.digest.Md5;
import ru.yandex.misc.digest.Sha256;
import ru.yandex.misc.digest.updatable.UpdatableDigests;
import ru.yandex.misc.io.IoUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.webdav.WebDavDigest;
import ru.yandex.misc.webdav.WebDavDigest.UpdatableWebDavDigest;

/**
 * @author bursy
 */
public class OnTheFlyDigester {
    private static final Logger logger = LoggerFactory.getLogger(OnTheFlyDigester.class);

    // WebDav digests
    private final File2 webDavDigestsFile;
    private final UpdatableWebDavDigest webDavDigester;
    // Basic hashsums
    private final UpdatableDigests digests;

    public OnTheFlyDigester(File2 webDavDigestsFile, long totalContentLength) {
        this.digests = new UpdatableDigests();
        this.webDavDigestsFile = webDavDigestsFile;

        try {
            OutputStream webDavDigestOutput = new FileOutputStream(webDavDigestsFile.getFile());
            this.webDavDigester = WebDavDigest.digester(totalContentLength, webDavDigestOutput);
        } catch (FileNotFoundException e) {
            logger.error("Webdav digest file not found: " + webDavDigestsFile.getName());
            throw IoUtils.translate(e);
        }
    }

    public void update(ByteArrayByteSequence b) {
        digests.update(b.array(), b.arrayOffset(), b.length());
        webDavDigester.update(b.array(), b.arrayOffset(), b.length());
    }

    public Digests completeAndGetDigests() {
        webDavDigester.complete();

        Tuple2<Md5.Sum, Sha256.Sum> sums = digests.asTuple();
        return new Digests(sums._1.hex(), sums._2.hex(), webDavDigestsFile);
    }
}
