package ru.yandex.chemodan.uploader.web.data.util;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author bursy
 */
public class UserUploadSpeedLimitManager {
    // this actually should be Tuple2List<Long, Long>, but dynamic properties don't support that
    // basically it should be structured as {uid1, limit1, uid2, limit2, ...}
    private final DynamicProperty<ListF<Long>> uploadLimitsByUid
            = DynamicProperty.cons("uploader-upload-limits-by-uid", Cf.list());

    public Option<DataSize> getMaxUploadSpeed(PassportUid passportUid) {
        Option<Long> limitO = Option.empty();

        long uid = passportUid.getUid();
        ListF<Long> limitsByUid = uploadLimitsByUid.get();

        // yeah it's ugly but at least it doesn't require memory
        for (int i = 0; i < limitsByUid.length() / 2; i++) {
            if (uid == limitsByUid.get(2 * i)) {
                limitO = Option.of(limitsByUid.get(2 * i + 1));
                break;
            }
        }

        return limitO.map(DataSize::fromBytes);
    }
}
