package ru.yandex.chemodan.uploader.web.exception;

/**
 * @author akirakozov
 */
public class HttpErrorException extends RuntimeException {

    private final int httpErrorCode;

    public HttpErrorException(String message, Throwable cause, int httpErrorCode) {
        super(message, cause);
        this.httpErrorCode = httpErrorCode;
    }

    public HttpErrorException(String message, int httpErrorCode) {
        super(message);
        this.httpErrorCode = httpErrorCode;
    }

    public HttpErrorException(Throwable cause, int httpErrorCode) {
        super(cause);
        this.httpErrorCode = httpErrorCode;
    }

    public int getHttpErrorCode() {
        return httpErrorCode;
    }
}
