package ru.yandex.chemodan.uploader.docviewer;

import java.awt.image.RenderedImage;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.config.UploaderCoreContextConfigurationForTests;
import ru.yandex.chemodan.util.IoUtils2;
import ru.yandex.chemodan.util.test.AbstractTest;
import ru.yandex.devtools.test.annotations.YaExternal;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 * @author ssytnik
 */
@YaExternal
@ContextConfiguration(classes = UploaderCoreContextConfigurationForTests.class)
public class DocviewerClientTest extends AbstractTest {

    @Autowired
    private DocviewerClientImpl docviewerClient;

    @Test
    public void generatePreview() throws IOException {
        MulcaId fileMulcaId = MulcaId.fromSerializedString("1000001.16011578.279257652198697004752003456222");

        InputStreamSource textResultSource = docviewerClient.getDocumentPreview(
                fileMulcaId, PassportUidOrZero.zero(), "");

        InputStreamSource memorySource = IoUtils2.loadInMemory(textResultSource);
        RenderedImage image = ImageIO.read(memorySource.getInput());
        Assert.equals(990, image.getWidth());
    }

    @Test
    public void supportedMimeTypes() {
        docviewerClient.updateCachedConvertationInfo();
        ConvertationInfo ci = docviewerClient.getConvertationInfo();
        Assert.equals(DataSize.fromBytes(629145600), ci.maxFileSize);
    }

    @Test
    public void supportedMimeTypesImage() {
        docviewerClient.setUseRemoteInfo(true);
        docviewerClient.updateCachedConvertationInfo();
        Assert.isTrue(docviewerClient.isSupportedMimeType("image/x-djvu"));
        Assert.isFalse(docviewerClient.isSupportedMimeType("image/png"));
        Assert.isTrue(docviewerClient.isSupportedMimeType("application/pdf"));
    }

    @Test
    public void checkEbookMimeTypes() {
        Assert.isTrue(docviewerClient.isSupportedMimeType("application/x-fictionbook+xml"));
        Assert.isTrue(docviewerClient.isSupportedMimeType("application/epub+zip"));
    }

    @Test
    public void checkXlsx() {
        Assert.isTrue(docviewerClient.isSupportedMimeType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
    }

    @Test
    public void checkXlsxFromRemote() {
        docviewerClient.setUseRemoteInfo(true);
        docviewerClient.updateCachedConvertationInfo();
        Assert.isTrue(docviewerClient.isSupportedMimeType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
    }


    @Test
    public void startConvertToHtml() {
        // just check 200 response from docviewer
        docviewerClient.startConvertToHtml(PassportUidOrZero.zero(), "ya-disk-public://aaa", Option.empty());
    }
}
