package ru.yandex.chemodan.uploader.mulca;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.uploader.config.UploaderCoreContextConfiguration;
import ru.yandex.chemodan.uploader.web.AbstractWebTestSupport;
import ru.yandex.chemodan.util.IoUtils2;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.test.Assert;

@ContextConfiguration(classes = {
        UploaderCoreContextConfiguration.class
})
public class MulcaAndAvatarsClientTest extends AbstractWebTestSupport {

    @Autowired
    private MulcaClient mulcaClient;

    @Test
    public void testIsInstanceOf() {
        Assert.A.isTrue(mulcaClient instanceof MulcaAndAvatarsClient);
    }

    @Test
    public void testAvatarsDownloadUrl() {
        Assert.A.equals("http://avatars.mdst.yandex.net/get-disk/1369823/2a000001664dc85795f2b955d7be4acea5a7/orig", mulcaClient.getDownloadUri(MulcaId.fromSerializedString("ava:disk:1369823:2a000001664dc85795f2b955d7be4acea5a7")).toString());
    }

    @Test
    public void testDiskDownloadUrl() {
        Assert.A.equals("http://storagetest.mail.yandex.net:10010/gate/get/320.yadisk:33812539.E330443:23926027316903745105?service=disk&ns=disk", mulcaClient.getDownloadUri(MulcaId.fromSerializedString("320.yadisk:33812539.E330443:23926027316903745105")).toString());
    }

    @Test
    public void testAvatarsDownload() {
        try {
            IoUtils2.loadInMemory(mulcaClient
                    .download(MulcaId.fromSerializedString("ava:disk:1369823:2a000001664dc85795f2b955d7be4acea5a7")));
        } catch (HttpException e) {
            Assert.A.isTrue(e.getStatusCode().isSome(404));
        }
    }

}
