package ru.yandex.chemodan.uploader.preview;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class AlbumPreviewManagerTest extends AbstractPreviewTest {
    @Autowired
    private AlbumPreviewManager albumPreviewManager;

    @Autowired
    private LogoManager logoManager;

    @Autowired
    private SizeExtractor sizeExtractor;

    @Value("${uploader.album.preview.default.width}")
    private int previewDefaultWidth;

    @Value("${uploader.album.preview.default.height}")
    private int previewDefaultHeight;

    @Before
    @Override
    public void init() {
        super.init();
        logoManager.setLogoFile(getImage("logo.png"));
    }

    @Test
    public void createAlbumPreview() {
        File2 albumPreview = getImage("cat.jpg");
        albumPreviewManager.generateAlbumPreview(albumPreview, "Hello World", "user");

        Assert.equals(new Dimension(previewDefaultWidth, previewDefaultHeight), sizeExtractor.getSize(albumPreview));
    }
}
