package ru.yandex.chemodan.uploader.preview;

import java.awt.image.BufferedImage;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.eclipse.jetty.io.RuntimeIOException;
import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.cl.ClassLoaderUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.mime.detect.MimeTypeDetector;
import ru.yandex.misc.test.Assert;

/**
 * @author nshmakov
 */
public class DcrawTest {

    private Dcraw sut = new Dcraw();

    @Test
    public void shouldExtractPreviewFromCr2() {
        InputStreamSource rawImage = ClassLoaderUtils.streamSourceForResource(getClass(), "img_2635.cr2");

        File2.withNewTempFile(file -> {
            rawImage.readTo(file);
            File2 preview = sut.extractPreviewFromRawImage(file);
            assertImageFormatAndSizeEqualsTo(preview, "image/jpeg", 1936, 1288);
        });
    }

    private void assertImageFormatAndSizeEqualsTo(File2 file, String mimeType, int width, int height) {
        Assert.equals(mimeType, MimeTypeDetector.detect(Option.empty(), Option.of(file)).get());
        try {
            BufferedImage image = ImageIO.read(file.getFile());
            Assert.equals(width, image.getWidth());
            Assert.equals(height, image.getHeight());
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}
