package ru.yandex.chemodan.uploader.preview;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class LogoManagerTest extends AbstractPreviewTest {
    @Autowired
    private LogoManager logoManager;

    @Autowired
    private SizeExtractor sizeExtractor;

    @Before
    @Override
    public void init() {
        super.init();
        logoManager.setLogoFile(getImage("logo.png"));
    }

    @Test
    public void createLogo() {
        File2 resizedLogo = tmpDir.child("resized-logo.png");

        Dimension need = new Dimension(150, 100);
        logoManager.createLogo(resizedLogo, need);

        Assert.equals(need, sizeExtractor.getSize(resizedLogo));
    }
}
