package ru.yandex.chemodan.uploader.preview;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.db.embedded.OS;
import ru.yandex.misc.db.embedded.sandbox.SandBoxTestResourceResolver;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class SizeExtractorTest extends AbstractPreviewTest {
    @Autowired
    private ImageMagickPathHelper imageMagickPathHelper;
    @Autowired
    private SizeExtractor sizeExtractor;

    // TOOD: move to common place
    private static class ImageMagickBinaryResolver extends SandBoxTestResourceResolver {
        public ImageMagickBinaryResolver() {
            // Builded version of ImageMagick-6.8.8-10, may be not all delegates of IM was added
            super(
                Cf.map(
                        OS.MAC, "362712646",
                        OS.LINUX, "362733885"
                ));
        }
    }


    /*
    @ClassRule
    public static final SandBoxResourceRule resourceRule = SandBoxResourceRule
            .create(new ImageMagickBinaryResolver())
            .withCompressType(TarArchiveExtractor.CompressType.GZIP)
            .withEnabledCache(true)
            .withParentDirName("embedded-image-magick")
            .withIsExecutable(s -> s.startsWith("ImageMagick-6.8.8-10/bin"))
            .build();


    @Before
    public void before() {
        imageMagickPathHelper.setBinaryDir(resourceRule.getExtractedResourceDir() + "/ImageMagick-6.8.8-10/bin/");
    }
    */

    @Test
    public void extractSizeJpg() {
        File2 picture = getImage("cat.jpg");
        Assert.equals(new Dimension(792, 1188), sizeExtractor.getSize(picture));
    }

    @Test
    public void extractSizePng() {
        File2 picture = getImage("cubs.png");
        Assert.equals(new Dimension(800, 600), sizeExtractor.getSize(picture));
    }

    @Test
    public void extractSizeSvg() {
        File2 picture = getImage("SVG-logo.svg");
        Assert.equals(new Dimension(195, 82), sizeExtractor.getSize(picture));
    }
}
