package ru.yandex.chemodan.uploader.preview.annotations;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.uploader.preview.AbstractPreviewTest;
import ru.yandex.chemodan.uploader.preview.LogoManager;
import ru.yandex.chemodan.uploader.preview.SizeExtractor;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class AlbumAnnotationManagerTest extends AbstractPreviewTest {
    @Autowired
    private AlbumAnnotationManager albumAnnotationManager;

    @Autowired
    private LogoManager logoManager;

    @Autowired
    private SizeExtractor sizeExtractor;

    @Value("${uploader.album.preview.annotation.font}")
    private String font;

    @Value("${uploader.album.preview.annotation.font.color}")
    private String fontColor;

    @Value("${uploader.album.preview.annotation.max.width}")
    private int maxWidth;

    @Value("${uploader.album.preview.annotation.max.height}")
    private int maxHeight;

    @Before
    @Override
    public void init()  {
        super.init();
        logoManager.setLogoFile(getImage("logo.png"));
    }

    @Test
    public void createSimpleAlbumAnnotation() {
        Annotation albumName = new Annotation(font, fontColor, 0, 0, 54, "Hello World");
        Annotation user = new Annotation(font, fontColor, 0, 0, 32, "user");
        Dimension logoDimension = new Dimension(150, 150);
        File2 annotation = albumAnnotationManager.createAlbumAnnotation(tmpDir, logoDimension, albumName, user);

        Assert.equals(new Dimension(maxWidth, 213), sizeExtractor.getSize(annotation));
    }

    @Test
    public void createBigAlbumAnnotation() {
        Annotation albumName = new Annotation(font, fontColor, 0, 0, 54,
                "Hello World\nHello World\nHello World\nHello World\nHello World\nHello World\nHello World\n");
        Annotation user = new Annotation(font, fontColor, 0, 0, 32, "user");
        Dimension logoDimension = new Dimension(150, 150);
        File2 annotation = albumAnnotationManager.createAlbumAnnotation(tmpDir, logoDimension, albumName, user);

        Assert.equals(new Dimension(maxWidth, 471), sizeExtractor.getSize(annotation));
    }
}
