package ru.yandex.chemodan.uploader.preview.annotations;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.uploader.preview.AbstractPreviewTest;
import ru.yandex.chemodan.uploader.preview.SizeExtractor;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class AnnotationFileGeneratorTest extends AbstractPreviewTest {
    @Autowired
    private AnnotationFileGenerator annotationFileGenerator;

    @Autowired
    private SizeExtractor sizeExtractor;

    @Value("${uploader.album.preview.annotation.font}")
    private String font;

    @Value("${uploader.album.preview.annotation.font.color}")
    private String fontColor;

    @Test
    public void createSimpleAnnotation() {
        File2 annotationFile = tmpDir.child("annotation.png");
        Annotation annotation = new Annotation(font, fontColor, 0, 0, 54, "Hello World");
        annotationFileGenerator.createFileWithAnnotation(annotationFile, annotation, 1000, -1);

        Assert.equals(new Dimension(1000, 39), sizeExtractor.getSize(annotationFile));
    }

    @Test
    public void createSimpleAnnotationWithOffset() {
        File2 annotationFile = tmpDir.child("annotation.png");
        Annotation annotation = new Annotation(font, fontColor, 0, 20, 54, "Hello World");
        annotationFileGenerator.createFileWithAnnotation(annotationFile, annotation, 1000, -1);

        Assert.equals(new Dimension(1000, 59), sizeExtractor.getSize(annotationFile));
    }

    @Test
    public void createBigAnnotation() {
        File2 annotationFile = tmpDir.child("annotation.png");
        Annotation annotation = new Annotation(font, fontColor, 0, 0, 54,
                "Hello World! Hello World! Hello World! Hello World! Hello World! Hello World! Hello World!");

        annotationFileGenerator.createFileWithAnnotation(annotationFile, annotation, 1000, -1);
        Assert.equals(new Dimension(1000, 139), sizeExtractor.getSize(annotationFile));

        annotationFileGenerator.createFileWithAnnotation(annotationFile, annotation, 1000, 100);
        Assert.equals(new Dimension(1000, 100), sizeExtractor.getSize(annotationFile));
    }
}
