package ru.yandex.chemodan.uploader.registry;

import java.util.concurrent.atomic.AtomicReference;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.uploader.UidOrSpecial;
import ru.yandex.chemodan.uploader.config.UploaderCoreContextConfigurationForTests;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.chemodan.util.test.AbstractTest;
import ru.yandex.chemodan.util.test.HttpRecorderRule;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.cl.ClassLoaderUtils;

/**
 * @author swined
 */
@ContextConfiguration(classes = {
        UploaderCoreContextConfigurationForTests.class,
        AvatarsUploadTest.Config.class
})
public class AvatarsUploadTest extends AbstractTest {

    @Configuration
    public static class Config {

        @Bean
        public BleedingEdge bleedingEdge() {
            return new BleedingEdge("uploader") {
                @Override
                public boolean isOnBleedingEdge(PassportUid uid) {
                    return uid.getUid() == 43;
                }
            };
        }

        @Bean
        public HttpRecorderRule httpRecorderRule() {
            return HttpRecorderRule.builder().prefix(System.getProperty("user.home") + "/arcadia/disk/uploader/src/test/resources/").build();
        }

    }

//    @Autowired
//    private HttpRecorderRule httpRecorderRule;

    @Autowired
    private Stages stages;

    private final InputStreamSource image = ClassLoaderUtils.fileForResource(
            "ru/yandex/chemodan/uploader/preview/cat.jpg");

    @Test
    public void testUpload() {
        stages.uploadFileToAvatarsF(stages.uploadToMulca(UidOrSpecial.special("test"), image).getMulcaId(), new AtomicReference<>()).apply();
    }

}
