package ru.yandex.chemodan.uploader.web;

import org.apache.http.client.HttpClient;
import org.dom4j.Element;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.UidOrSpecial;
import ru.yandex.chemodan.uploader.browser.BrowserMdsTestContextConfiguration;
import ru.yandex.chemodan.uploader.registry.ApiVersion;
import ru.yandex.chemodan.uploader.services.ServiceFileId;
import ru.yandex.chemodan.uploader.web.client.UploaderClient;
import ru.yandex.chemodan.util.http.HttpClientUtils;
import ru.yandex.chemodan.util.test.TestUser;
import ru.yandex.devtools.test.annotations.YaExternal;
import ru.yandex.inside.mds.Mds;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.inside.mds.MdsPostResponse;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.random.Random2;

/**
 * @author metal
 * @author akirakozov
 */
@YaExternal
@ContextConfiguration(classes = {BrowserMdsTestContextConfiguration.class})
public class WebConvertToMsOoxmlFormatTest extends AbstractWebTestSupport {

    @Autowired
    private Mds browserMds;

    @Test
    public void uploadDocumentToMulcaAndTryToConvertItToNewMsFormat() throws Exception {
        UploaderClient uploaderClient = newUploaderClient();
        ClassPathResourceInputStreamSource source = getSourceFileAsStream();
        MulcaId originalMulcaId = uploaderClient
                .uploadToDiskUntilDone(CHE_FILE, source)
                .getFileMulcaId().get();

        ServiceFileId serviceFileId = new ServiceFileId(TestUser.uid, originalMulcaId.getStidCheckNoPart());
        convertDocumentToNewMsFormat(serviceFileId, ChemodanService.MULCA, CHE_FILE);
    }

    @Test
    public void convertMailAttachment() {
        ServiceFileId serviceFileId = new ServiceFileId(TestUser.uid2, "162411061562048528/1.1");
        convertDocumentToNewMsFormat(serviceFileId, ChemodanService.MAIL2,
                ChemodanFile.consWithoutFileId(UidOrSpecial.uid(TestUser.uid2), "/disk/test.doc"));
    }

    @Test
    public void uploadBrowserDocumentAndTryToConvertItToNewMsFormat() throws Exception {
        Option<MdsFileKey> mdsFileKey = Option.empty();
        try {
            String filename = Random2.R.nextString(10);
            MdsPostResponse response = browserMds.upload(filename, getSourceFileAsStream());
            mdsFileKey = Option.of(response.getKey());
            ServiceFileId serviceFileId = new ServiceFileId(TestUser.uid, mdsFileKey.get().serialize());

            convertDocumentToNewMsFormat(serviceFileId, ChemodanService.BROWSER, CHE_FILE);
        } finally {
            mdsFileKey.forEach(browserMds::delete);
        }
    }

    private void convertDocumentToNewMsFormat(ServiceFileId serviceFileId, ChemodanService service, ChemodanFile file)
    {
        HttpClient httpClient = ApacheHttpClientUtils.singleConnectionClient(Timeout.seconds(5));

        Element response = HttpClientUtils.parseXmlResponse(httpClient,
                HttpClientUtils.httpPost(
                        "http://localhost:" + uploaderHttpPorts.getControlPort() + ApiUrls.CONVERT_TO_MS_OOXML_FORMAT,
                        UploaderClient.toParameterMap(file)
                                .plus1(ApiArgs.API_VERSION, ApiVersion.V_0_2.toSerializedString())
                                .plus1(ApiArgs.SOURCE_SERVICE, service)
                                .plus1(ApiArgs.SERVICE_FILE_ID, serviceFileId.toSerializedString())));
        String pollUrl = response.attributeValue("poll-result");

        pollStatusUntilCompleted(httpClient, pollUrl);
    }

    private ClassPathResourceInputStreamSource getSourceFileAsStream() {
        return new ClassPathResourceInputStreamSource(WebConvertToMsOoxmlFormatTest.class, "Word_97_001p.doc");
    }

}
