package ru.yandex.chemodan.uploader.web;

import org.apache.http.client.HttpClient;
import org.dom4j.Element;
import org.junit.Test;

import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.registry.ApiVersion;
import ru.yandex.chemodan.uploader.services.ServiceFileId;
import ru.yandex.chemodan.uploader.web.client.UploaderClient;
import ru.yandex.chemodan.util.http.HttpClientUtils;
import ru.yandex.chemodan.util.test.TestUser;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author metal
 * @author akirakozov
 */
public class WebExtractFileFromArchiveTest extends AbstractWebTestSupport {

    @Test
    public void uploadArchiveAndTryToGetSingleFile() throws Exception {
        UploaderClient uploaderClient = newUploaderClient();
        ClassPathResourceInputStreamSource source = new ClassPathResourceInputStreamSource(
                WebExtractFileFromArchiveTest.class,
                "precise.tar.gz");
        MulcaId originalMulcaId = uploaderClient
                .uploadToDiskUntilDone(CHE_FILE, source)
                .getFileMulcaId().get();

        ServiceFileId serviceFileId = new ServiceFileId(TestUser.uid, originalMulcaId.getStidCheckNoPart());
        extractFileFromArchive(serviceFileId, ChemodanService.MULCA);
    }

    @Test
    public void extractFileFromMailAttachment() throws Exception {
        extractFileFromArchive(new ServiceFileId(TestUser.uid2, "162411061562048525/1.1"), ChemodanService.MAIL2);
    }

    private void extractFileFromArchive(ServiceFileId serviceFileId, ChemodanService service) {
        HttpClient httpClient = ApacheHttpClientUtils.singleConnectionClient(Timeout.seconds(5));
        Element response = HttpClientUtils.parseXmlResponse(httpClient,
                HttpClientUtils.httpPost(
                        "http://localhost:" + uploaderHttpPorts.getControlPort() + ApiUrls.EXTRACT_FILE_FROM_ARCHIVE_URL,
                        UploaderClient.toParameterMap(CHE_FILE)
                                .plus1(ApiArgs.API_VERSION, ApiVersion.V_0_2.toSerializedString())
                                .plus1(ApiArgs.SOURCE_SERVICE, service)
                                .plus1(ApiArgs.SERVICE_FILE_ID, serviceFileId.toSerializedString())
                                .plus1(ApiArgs.FILE_TO_EXTRACT, "a/lala.txt")));
        String pollUrl = response.attributeValue("poll-result");
        pollStatusUntilCompleted(httpClient, pollUrl);
    }

}
