package ru.yandex.chemodan.uploader.web;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;

import org.apache.http.client.methods.HttpGet;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.test.ClassLoaderTestUtils;
import ru.yandex.chemodan.uploader.preview.LogoManager;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.serialize.JsonParser;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.cl.ClassLoaderUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.test.TestDirRule;

/**
 * @author metal
 */
public class WebGenerateAlbumPreviewTest extends AbstractWebTestSupport {
    private static final String TEST_MULCA_IDENTIFIER = "tmp";

    @Autowired
    private MulcaClient mulcaClient;
    @Autowired
    private LogoManager logoManager;

    @Value("${uploader.album.preview.default.width}")
    private int previewDefaultWidth;
    @Value("${uploader.album.preview.default.height}")
    private int previewDefaultHeight;

    @Rule
    public final TestDirRule testDir = new TestDirRule();

    @Before
    public void init()  {
        String logoFileName = "logo.png";
        File2 tmpLogoFile = testDir.testDir.child(logoFileName);
        ClassLoaderUtils.streamSourceForResource(LogoManager.class, logoFileName).readTo(tmpLogoFile);
        logoManager.setLogoFile(tmpLogoFile);
    }

    private MulcaId getOriginalMulcaId() {
        InputStreamSource source = ClassLoaderTestUtils.byteStreamSourceForResource(
                WebGenerateAlbumPreviewTest.class, "300.jpg");
        return mulcaClient.upload(source, TEST_MULCA_IDENTIFIER);
    }

    @Test
    public void generateDynamicAlbumPreview() throws IOException {
        MulcaId originalMulcaId = getOriginalMulcaId();

        String url = UrlUtils.addParameter(
                "http://localhost:" + uploaderHttpPorts.getControlPort() + ApiUrls.GENERATE_ALBUM_PREVIEW_URL,
                ApiArgs.MULCA_ID, originalMulcaId.getStidCheckNoPart(),
                ApiArgs.ALBUM_NAME, "Hello World!",
                ApiArgs.USER_NAME, "noname");
        url = UrlUtils.addParameter(url, ApiArgs.DYNAMIC_ALBUM_PREVIEW, "true");

        BufferedImage img = ImageIO.read(new URL(url));

        Assert.equals(previewDefaultWidth, img.getWidth());
        Assert.equals(previewDefaultHeight, img.getHeight());
    }

    @Test
    public void generateStaticAlbumPreview() {
        MulcaId originalMulcaId = getOriginalMulcaId();

        String url = UrlUtils.addParameter(
                "http://localhost:" + uploaderHttpPorts.getControlPort() + ApiUrls.GENERATE_ALBUM_PREVIEW_URL,
                ApiArgs.MULCA_ID, originalMulcaId.getStidCheckNoPart(),
                ApiArgs.ALBUM_NAME, "Hello World!",
                ApiArgs.USER_NAME, "noname");

        String json = ApacheHttpClientUtils.executeReadString(new HttpGet(url));

        JsonObject response = (JsonObject) JsonParser.getInstance().parse(json);
        Assert.isTrue(response.get("album-preview-mulca-id") instanceof JsonString);
        String mulcaIdString = ((JsonString) response.get("album-preview-mulca-id")).getString();
        Assert.isTrue(StringUtils.isNotBlank(mulcaIdString));

        mulcaClient.delete(MulcaId.fromSerializedString(mulcaIdString));
    }
}
