package ru.yandex.chemodan.uploader.web;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;

import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.joda.time.Duration;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.uploader.preview.PreviewImageSize;
import ru.yandex.chemodan.uploader.registry.ApiVersion;
import ru.yandex.chemodan.uploader.web.client.UploaderClient;
import ru.yandex.chemodan.uploader.web.control.sync.GeneratePreviewSyncRequest;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class WebGeneratePreviewTest extends AbstractWebTestSupport {

    @Autowired
    private GeneratePreviewSyncRequest generatePreviewServlet;

    private UploaderClient uploaderClient;
    private MulcaId originalMulcaId;

    @Before
    public void init() {
        uploaderClient = newUploaderClient();
        ClassPathResourceInputStreamSource source =
                new ClassPathResourceInputStreamSource(WebGeneratePreviewTest.class, "300.jpg");
        originalMulcaId = uploaderClient.uploadToDiskUntilDone(CHE_FILE, source).getFileMulcaId().get();
    }

    @Test
    public void wrongParam() throws Exception {
        String url = UrlUtils.addParameter(getBaseUrl(originalMulcaId), ApiArgs.PREVIEW_SIZE, PreviewImageSize.XS.name());
        url = UrlUtils.addParameter(url, ApiArgs.PREVIEW_QUALITY, -1);
        ApacheHttpClientUtils.execute(new HttpGet(url), (response) -> {
                Assert.equals(400, response.getStatusLine().getStatusCode());
                return null;
            });
    }

    @Test
    public void uploadAndGeneratePreview() throws Exception {
        String baseUrl = getBaseUrl(originalMulcaId);

        BufferedImage img = ImageIO.read(new URL(
                UrlUtils.addParameter(baseUrl, ApiArgs.PREVIEW_SIZE, PreviewImageSize.XS.name())));

        Assert.equals(66, img.getWidth());
        Assert.equals(100, img.getHeight());

        img = ImageIO.read(new URL(
                UrlUtils.addParameter(baseUrl, ApiArgs.PREVIEW_SIZE, "100x200", ApiArgs.PREVIEW_CROP, "true")));

        Assert.equals(100, img.getWidth());
        Assert.equals(200, img.getHeight());

        img = ImageIO.read(new URL(
                UrlUtils.addParameter(baseUrl, ApiArgs.PREVIEW_SIZE, "100x", ApiArgs.PREVIEW_CROP, "true")));

        Assert.equals(100, img.getWidth());
        Assert.equals(100, img.getHeight());

        img = ImageIO.read(new URL(UrlUtils.addParameter(baseUrl, ApiArgs.PREVIEW_SIZE, "100x")));

        Assert.equals(100, img.getWidth());
        Assert.equals(151, img.getHeight());
    }

    @Test
    public void watermarks() throws IOException {
        String baseUrl = getBaseUrl(originalMulcaId);

        ImageIO.read(new URL(UrlUtils.addParameter(baseUrl, ApiArgs.PREVIEW_SIZE, "100x100", ApiArgs.PREVIEW_LOGO_POSITION, "south_east")));
        ImageIO.read(new URL(UrlUtils.addParameter(baseUrl, ApiArgs.PREVIEW_SIZE, "100x100", ApiArgs.PREVIEW_LOGO_POSITION, "north_west")));
        ImageIO.read(new URL(UrlUtils.addParameter(baseUrl, ApiArgs.PREVIEW_SIZE, "100x100", ApiArgs.PREVIEW_LOGO_POSITION, "center")));
        ImageIO.read(new URL(UrlUtils.addParameter(baseUrl, ApiArgs.PREVIEW_SIZE, "100x100", ApiArgs.PREVIEW_LOGO_POSITION, "center_new")));
    }

    @Test
    @Ignore
    public void timeout() throws Exception {
        try {
            testGeneratePreviewServletTimeout();
        } finally {
            generatePreviewServlet.setTimeout(Duration.standardMinutes(1));
        }
    }

    private void testGeneratePreviewServletTimeout() {
        generatePreviewServlet.setTimeout(Duration.millis(1L));
        String url = UrlUtils.addParameter(getBaseUrl(originalMulcaId), ApiArgs.PREVIEW_SIZE, PreviewImageSize.XS.name());

        ApacheHttpClientUtils.execute(new HttpGet(url), new ResponseHandler<Void>() {
            public Void handleResponse(HttpResponse response) throws IOException {
                Assert.equals(408, response.getStatusLine().getStatusCode());
                return null;
            }
        });
    }

    private String getBaseUrl(MulcaId originalMulcaId) {
        return UrlUtils.addParameter(
                "http://localhost:" + uploaderHttpPorts.getControlPort() + ApiUrls.GENERATE_PREVIEW_URL,
                ApiArgs.API_VERSION, ApiVersion.V_0_2.toSerializedString(),
                ApiArgs.MULCA_ID, originalMulcaId.getStidCheckNoPart());
    }
}
