package ru.yandex.chemodan.uploader.web;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.client.methods.HttpGet;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.uploader.web.control.LoadingStatusServlet;
import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.when;

/**
 * @author nshmakov
 */
public class WebLoadingStatusTest extends AbstractWebTestSupport {

    private ObjectMapper objectMapper = new ObjectMapper();
    private String loadingStatusUrl;

    @Autowired
    private LoadingStatusServlet loadingStatusServlet;
    private CoolPingServlet availabilityCheckerMock;
    private HttpGet request;

    @Before
    public void init() throws IOException {
        loadingStatusUrl = "http://localhost:" + uploaderHttpPorts.getControlPort() + ApiUrls.LOADING_STATUS;
        request = new HttpGet(loadingStatusUrl);

        availabilityCheckerMock = Mockito.mock(CoolPingServlet.class);
        loadingStatusServlet.setCoolPingServlet(availabilityCheckerMock);
    }

    @Test
    public void shouldComputeLoadingStatusForAllTypes() throws IOException {
        when(availabilityCheckerMock.isAvailable()).thenReturn(true);

        String response = ApacheHttpClientUtils.executeReadString(request);
        Map<String, String> result = objectMapper.readValue(response, Map.class);

        Assert.equals(6, result.size());
    }

    @Test
    public void shouldReturn503WhenNotAvailable() {
        when(availabilityCheckerMock.isAvailable()).thenReturn(false);

        ApacheHttpClientUtils.execute(request, response -> {
            Assert.equals(HttpStatus.SC_503_SERVICE_UNAVAILABLE, response.getStatusLine().getStatusCode());
            return null;
        });
    }

    // TODO: remove after migration
    @Test
    public void shouldFilterLoadingStatusWhenTypesIsSpecified() throws IOException {
        when(availabilityCheckerMock.isAvailable()).thenReturn(true);

        String response = ApacheHttpClientUtils.executeReadString(new HttpGet(loadingStatusUrl + "?types=la"));
        Map<String, String> result = objectMapper.readValue(response, Map.class);

        Assert.equals(1, result.size());
    }
}
