package ru.yandex.chemodan.uploader.web;

import org.apache.http.client.methods.HttpGet;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.test.ClassLoaderTestUtils;
import ru.yandex.chemodan.test.MulcaTestUtils;
import ru.yandex.chemodan.uploader.exif.ExifToolTest;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.serialize.JsonParser;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class WebRegenerateExifTest extends AbstractWebTestSupport {

    @Autowired
    private MulcaClient mulcaClient;

    private String regenerateExif(InputStreamSource source) {
        return regenerateExif(Option.of(source));
    }

    private String regenerateExif(Option<InputStreamSource> source) {
        MulcaId originalMulcaId = source.isPresent() ?
                mulcaClient.upload(source.get(), "tmp") :
                MulcaTestUtils.FAKE_MULCA_ID;

        String url = UrlUtils.addParameters(
                "http://localhost:" + uploaderHttpPorts.getControlPort() + ApiUrls.REGENERATE_EXIF_URL,
                Cf.<String, Object>map(ApiArgs.MULCA_ID, originalMulcaId.getStidCheckNoPart()));

        return ApacheHttpClientUtils.executeReadString(new HttpGet(url));
    }

    @Test
    public void regenerateExif() {
        String json = regenerateExif(
                ClassLoaderTestUtils.byteStreamSourceForResource(ExifToolTest.class, "small.jpg"));
        JsonObject response = (JsonObject) JsonParser.getInstance().parse(json);
        Assert.isTrue(response.get("exif") instanceof JsonObject);
        Assert.isFalse(((JsonObject) response.get("exif")).isEmpty());
        Assert.isTrue(response.get("mid") instanceof JsonString);
    }

    @Test
    public void regenerateExifForFileWithoutExif() {
        String json = regenerateExif(
                ClassLoaderTestUtils.byteStreamSourceForResource(WebRegeneratePreviewTest.class, "empty.jpg"));
        JsonObject response = (JsonObject) JsonParser.getInstance().parse(json);
        Assert.isTrue(response.get("exif") instanceof JsonObject);
        Assert.isTrue(((JsonObject) response.get("exif")).isEmpty());
        Assert.equals("none", ((JsonString) response.get("mid")).getValue());
    }

    @Test
    public void regenerateExifWithNotFoundError() {
        try {
            regenerateExif(Option.empty());
            Assert.fail();
        } catch (HttpException e) {
            Assert.equals(HttpStatus.SC_404_NOT_FOUND, e.getStatusCode().get());
        }
    }
}
