package ru.yandex.chemodan.app.urlshortener.api;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.urlshortener.service.UrlShortenerManager;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.pojo.JsonPojoResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author conterouz
 */
@Configuration
@Import({
        A3JettyContextConfiguration.class
})
public class UrlShortenerApiContextConfiguration {
    @Bean
    public A3JettyConfiguration a3JettyConfiguration() {
        return new A3JettyConfiguration(
                Tuple2List.fromPairs("/*", "")
        );
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo) {

        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator.getBuilder()
                .addResultSerializers(Cf.list(
                        new JsonPojoResultSerializer(new BenderMapper())))

                .addInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo)))

                .setResultType(MediaType.TEXT_HTML);

        return configurator.configure();
    }

    @Bean
    public UrlShortenerActions urlShortenerActions(
            UrlShortenerManager urlShortenerManager,
            @Value("${web.public.url}") String webPrefix,
            @Value("${telemost.public.url}") String telemostPrefix)
    {
        return new UrlShortenerActions(urlShortenerManager, webPrefix, telemostPrefix);
    }

}
