package ru.yandex.chemodan.app.urlshortener.dao;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.misc.db.embedded.ConditionalOnMissingEmbeddedDb;

/**
 * @author vpronto
 */
@Configuration
@Import(UrlShortenerJdbcContextConfiguration.class)
@ConditionalOnMissingEmbeddedDb
public class UrlShortenerDataSourceContextConfiguration {

    @Bean
    @OverridableValuePrefix("urlshortener")
    public DataSourceProperties urlshortenerDataSourceProperties() {
        return new DataSourceProperties();
    }

}
