package ru.yandex.chemodan.app.urlshortener.dao;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author conterouz
 */
@Configuration
@Import(JdbcDatabaseConfiguratorContextConfiguration.class)
public class UrlShortenerJdbcContextConfiguration {

    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;

    @Autowired
    private  JdbcDatabaseConfigurator dbConfigurator;

    @Bean
    public JdbcDatabaseConfigurator dbConfigurator(DataSourceProperties urlshortenerDataSourceProperties) {
        return dbConfiguratorConfig.consJdbcConfigurator(urlshortenerDataSourceProperties);
    }

    @Bean
    public DataSource urlshortenerDataSource() {
        return dbConfigurator.configureDataSource();
    }

    @Bean
    public JdbcTemplate3 baseJdbcTemplate() {
        return dbConfigurator.consTemplate(urlshortenerDataSource());
    }

    @Bean
    public UrlShortenerJdbcDao urlShortenerJdbcDao(JdbcTemplate3 baseJdbcTemplate) {
        return new UrlShortenerJdbcDao(baseJdbcTemplate);
    }
}
