package ru.yandex.chemodan.app.urlshortener.dao;

import org.joda.time.Instant;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author conterouz
 */
public class UrlShortenerJdbcDao {

    private final JdbcTemplate3 jdbcTemplate;

    public UrlShortenerJdbcDao(JdbcTemplate3 jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private final static RowMapper<UrlShortenerMappingItem> M = (rs, rowNum) -> UrlShortenerMappingItem.builder()
            .shortUrl(rs.getString("short_url"))
            .prefixId(rs.getShort("prefix_id"))
            .url(rs.getString("url"))
            .eolTime(Option.ofNullable(rs.getTimestamp("eol_time")).map(Instant::new))
            .build();

    public boolean insert(UrlShortenerMappingItem urlShortenerMappingItem) {
        String q = "INSERT INTO mapping values (?, ?, ?, ?) ON CONFLICT DO NOTHING";
        return jdbcTemplate.update(
                q,
                urlShortenerMappingItem.getShortUrl(),
                urlShortenerMappingItem.getPrefixId(),
                urlShortenerMappingItem.getUrl(),
                urlShortenerMappingItem.getEolTime().getOrNull()
        ) > 0;
    }

    public boolean update(UrlShortenerMappingItem urlShortenerMappingItem) {
        String q = "UPDATE mapping SET prefix_id = ?, url = ?, eol_time = ? WHERE short_url = ?";
        return jdbcTemplate.update(
                q,
                urlShortenerMappingItem.getPrefixId(),
                urlShortenerMappingItem.getUrl(),
                urlShortenerMappingItem.getEolTime().getOrNull(),
                urlShortenerMappingItem.getShortUrl()
        ) > 0;
    }

    public Option<UrlShortenerMappingItem> find(String shortUrl) {
        return jdbcTemplate.queryForOption("SELECT * FROM mapping WHERE short_url = ?", M, shortUrl);
    }
}
