package ru.yandex.chemodan.app.urlshortener.service;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.urlshortener.dao.UrlShortenerDataSourceContextConfiguration;
import ru.yandex.chemodan.app.urlshortener.dao.UrlShortenerJdbcDao;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        UrlShortenerDataSourceContextConfiguration.class
})
public class UrlShortenerManagerContextConfiguration {

    @Bean
    public UrlShortenerManager urlShortenerManager(
            DynamicPropertyManager dynamicPropertyManager,
            UrlShortenerJdbcDao urlShortenerJdbcDao,
            @Value("${urlshortener.clck.ttl}") Duration ttl)
    {
        UrlShortenerManager manager = new UrlShortenerManager(urlShortenerJdbcDao, ttl);
        dynamicPropertyManager.registerAndFireWatcher(
                // TODO: add default QA and testing prefixes
                new DynamicProperty<>("", Cf.list(
                        "1", "https://disk.yandex.net/disk/public/?hash=",
                        "2", "https://disk-test.disk.yandex.ru/public/?hash=",
                        "3", "https://disk.yandex.net/albums/public/?key="
                )),

                list -> {
                    MapF<Short, String> prefixesMap = list
                            .paginate(2)
                            .filter(lst -> lst.size() == 2)
                            .filter(lst -> Cf.Short.parseSafe(lst.first()).isPresent())
                            .map(lst -> Tuple2.tuple(Cf.Short.parse(lst.first()), lst.get(1)))
                            .toMap(t -> t);

                    manager.setPrefixes(prefixesMap);
                }
        );
        return manager;
    }
}
