package ru.yandex.chemodan.app.urlshortener.service;

import ru.yandex.bolts.function.Function0;
import ru.yandex.misc.codec.FastBase64Coder;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.random.Random2;

public enum UrlShortenerUrlType implements StringEnum {
    YA_DISK("yadisk", 'd'),
    YA_DISK_IMAGE("yadisk-image", 'i'),
    YA_DISK_IMAGE_("yadisk_image", 'i'),
    YA_DISK_ALBUM("yadisk-album", 'a'),
    YA_DISK_ALBUM_("yadisk_album", 'a'),
    TELEMOST_JOIN("telemost-join", 'j', UrlShortenerUrlType::generateNewRandomDigitString)
    ;

    private final String name;
    private final Character letter;
    private final Function0<String> generator;

    UrlShortenerUrlType(String name, Character letter, Function0<String> generator) {
        this.name = name;
        this.letter = letter;
        this.generator = generator;
    }

    UrlShortenerUrlType(String name, Character letter) {
        this.name = name;
        this.letter = letter;
        this.generator = UrlShortenerUrlType::generateNewRandomString;
    }

    public static String generateNewRandomString() {
        byte[] buf = new byte[10];
        Random2.R.nextBytes(buf);
        return FastBase64Coder.encodeForUrl(buf);
    }

    public static String generateNewRandomDigitString() {
        return Random2.R.nextDigits(14);
    }

    @Override
    public String value() {
        return name;
    }

    public Character getLetter() {
        return letter;
    }

    public static final StringEnumResolver<UrlShortenerUrlType> R = StringEnumResolver.r(UrlShortenerUrlType.class);


    public String getShortUrl() {
        return letter + "/" + generator.apply();
    }
}

