package ru.yandex.chemodan;

import org.junit.Test;
import org.springframework.context.ConfigurableApplicationContext;

import ru.yandex.chemodan.app.videostreaming.VideoStreamingMain;
import ru.yandex.chemodan.boot.ChemodanPropertiesLoadStrategy;
import ru.yandex.chemodan.test.TestHelper;
import ru.yandex.chemodan.util.AppNameHolder;
import ru.yandex.misc.property.load.PropertiesLoader;

/**
 * @author tolmalev
 */
public class VideostreamingContextTest {
    static {
        TestHelper.initialize();
    }

    @Test
    public void testContext() {
        VideoStreamingMain main = new VideoStreamingMain();
        AppNameHolder.setIfNotPresent(main.applicationName());
        PropertiesLoader.initialize(new ChemodanPropertiesLoadStrategy(main.applicationName(), true));
        ConfigurableApplicationContext appContext = main.loadApplicationContext();
        appContext.close();
    }
}
