package ru.yandex.chemodan.app.videostreaming;

import java.io.IOException;
import java.net.URI;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.prefetch.HlsSegmentPrefetch;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DiskStreamingSegmentPrefetch implements HlsSegmentPrefetch<MpfsSourceMeta> {
    private static final Logger logger = LoggerFactory.getLogger(DiskStreamingSegmentPrefetch.class);

    private final DiskStreamingUrlBuilder urlBuilder;
    private final HttpClient httpClient;

    public DiskStreamingSegmentPrefetch(DiskStreamingUrlBuilder urlBuilder, HttpClient httpClient) {
        this.urlBuilder = urlBuilder;
        this.httpClient = httpClient;
    }

    @Override
    public boolean prefetch(HlsSegmentMeta<MpfsSourceMeta> segmentMeta) {
        int segmentIndex = segmentMeta.getIndex();
        try {
            URI prefetchUrl = urlBuilder.getSegmentPrefetchUrl(segmentMeta);
            logger.info("Trying to prefetch segment#{} using {}", segmentIndex, prefetchUrl);
            int statusCode = httpGet(prefetchUrl);
            if (statusCode == 200) {
                return true;
            } else {
                logger.error("Unable to prefetch segment#{}: status code = {}", segmentIndex, statusCode);
                return false;
            }
        } catch (Exception e) {
            logger.error("Unable to prefetch segment#{}", segmentIndex, e);
            return false;
        }
    }

    private int httpGet(URI prefetchUrl) throws IOException {
        HttpResponse response = httpClient.execute(new HttpGet(prefetchUrl));
        EntityUtils.consume(response.getEntity());
        return response.getStatusLine().getStatusCode();
    }
}
