package ru.yandex.chemodan.app.videostreaming;

import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.videostreaming.framework.hls.StreamingUrlParams;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DiskStreamingUrlBuilderTest {
    @Test
    public void test() {
        Assert.equals(
                "http://disk-streaming.ape.yandex.net/hls/info/playlist.m3u8",
                cons()
                        .new Builder(
                                new StreamingUrlParams()
                                        .withUseHttp(true)
                                        .withServerUri(new UriBuilder("https://disk-streaming.ape.yandex.net").build())
                                        .withParameters(
                                                "stid", "320.yadisk:338284141.E398212:8139553492362305384830206771",
                                                "use-http", "true"
                                        )
                        )
                        .setPath("/hls/info/playlist.m3u8")
                        .build()
                        .toString()
        );
    }

    @Test
    public void testMultipleParams() {
        Assert.equals(
                "https://disk-streaming.ape.yandex.net/hls/info/playlist.m3u8?disable_cache=true",
                cons()
                        .new Builder(
                                new StreamingUrlParams()
                                        .withUseHttp(false)
                                        .withServerUri(new UriBuilder("https://disk-streaming.ape.yandex.net").build())
                                        .withParameters(
                                                "stid", "320.yadisk:338284141.E398212:8139553492362305384830206771",
                                                "param", "value",
                                                "disable_cache", "true"
                                        )
                        )
                        .setPath("/hls/info/playlist.m3u8")
                        .build()
                        .toString()
        );
    }

    @Test
    public void testRelativeUrlWithQs() {
        Assert.equals(
                "1.ts?exists=true",
                cons().getRelativePlaylistItemUri("1.ts", Tuple2List.fromPairs("exists", "true"))
        );
    }

    @Test
    public void testRelativeUrlWithoutQs() {
        Assert.equals(
                "1.ts",
                cons().getRelativePlaylistItemUri("1.ts")
        );
    }

    private static DiskStreamingUrlBuilder cons() {
        return new DiskStreamingUrlBuilder(null, Cf.map(), Duration.standardHours(4));
    }
}
