package ru.yandex.chemodan.app.videostreaming;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.ip.IpAddress;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MpfsSourceMetaTest {
    @Test
    public void testSerialize() {
        MpfsSourceMeta mpfsSourceMeta = new MpfsSourceMeta(
                MulcaId.fromSerializedString("320.yadisk:530465586.E265610:4010379654102333439449412643589"),
                Option.of(PassportUidOrZero.fromUid(1L)),
                Option.of(PassportUidOrZero.fromUid(2L)),
                false,
                Option.of(IpAddress.parse("87.250.250.242"))
        );
        Assert.equals(
                "{"
                        + "\"mulcaId\":{"
                            + "\"stid\":\"320.yadisk:530465586.E265610:4010379654102333439449412643589\","
                            + "\"part\":\"\""
                        + "},"
                        + "\"ownerUid\":1,"
                        + "\"consumerUid\":2,"
                        + "\"publicUser\":false,"
                        + "\"userIp\":\"87.250.250.242\""
                + "}",
                mpfsSourceMeta.serialize()
        );
    }

    @Test
    public void testParse() {
        Assert.equals(
                new MpfsSourceMeta(
                        MulcaId.fromSerializedString("320.yadisk:530465586.E265610:4010379654102333439449412643589"),
                        Option.of(PassportUidOrZero.fromUid(1L)),
                        Option.of(PassportUidOrZero.fromUid(2L)),
                        false,
                        Option.of(IpAddress.parse("2a02:6b8::2:242"))
                ),
                MpfsSourceMeta.parse(
                    "{"
                        + "\"mulcaId\":{"
                            + "\"stid\":\"320.yadisk:530465586.E265610:4010379654102333439449412643589\","
                            + "\"part\":\"\""
                        + "},"
                        + "\"ownerUid\":1,"
                        + "\"consumerUid\":2,"
                        + "\"publicUser\":false,"
                        + "\"userIp\":\"2a02:6b8::2:242\""
                    + "}"
                )
        );
    }

    @Test
    public void testParseStid() {
        Assert.equals(
                new MpfsSourceMeta(
                        MulcaId.fromSerializedString("320.yadisk:530465586.E265610:4010379654102333439449412643589")
                ),
                MpfsSourceMeta.parse("320.yadisk:530465586.E265610:4010379654102333439449412643589")
        );
    }
}
