package ru.yandex.chemodan.app.videostreaming;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.videostreaming.config.VideoStreamingHlsConfig;
import ru.yandex.chemodan.app.videostreaming.config.VideoStreamingRequestConfig;
import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.chemodan.videostreaming.framework.config.HlsConfig;
import ru.yandex.chemodan.videostreaming.framework.util.SingleWarJettyUtil;
import ru.yandex.chemodan.videostreaming.framework.web.HlsServlet;
import ru.yandex.chemodan.videostreaming.framework.web.HlsVideoInfoServlet;
import ru.yandex.chemodan.videostreaming.framework.web.InternalAccessFilter;
import ru.yandex.chemodan.videostreaming.framework.web.VideoStreamingMuteErrorHandler;
import ru.yandex.misc.web.servlet.PidServlet;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import({VideoStreamingHlsConfig.class, VideoStreamingRequestConfig.class})
public class VideoStreamingConfig {
    private final HlsConfig hlsConfig;

    private final VideoStreamingRequestConfig requestConfig;

    @Value("${external-jetty.http.port}")
    private int httpPort;

    @Value("${external-jetty.http.max-threads}")
    private int maxThreads;

    @Value("${external-jetty.http.min-threads}")
    private int minThreads;

    @Value("${external-jetty.http.max-queue-length}")
    private int maxQueueLength;


    @Autowired
    public VideoStreamingConfig(HlsConfig hlsConfig, VideoStreamingRequestConfig requestConfig) {
        this.hlsConfig = hlsConfig;
        this.requestConfig = requestConfig;
    }

    @Bean
    @Qualifier("externalJetty")
    public SingleWarJetty externalJetty(CoolPingServlet coolPingServlet) {
        SingleWarJetty jetty = SingleWarJettyUtil.consSingleWarJetty(httpPort, maxThreads, minThreads, maxQueueLength);

        jetty.addServletMapping("/ping", coolPingServlet);
        jetty.addServletMapping("/pid", new PidServlet());
        jetty.addServletMapping("/" + HlsServlet.URL_PREFIX + "/*", hlsConfig.hlsServlet());
        jetty.addServletMapping("/" + HlsVideoInfoServlet.URL_PREFIX + "/*", hlsConfig.hlsVideoInfoServlet());

        jetty.addFilterMapping("/*", internalAccessFilter());

        jetty.initialize();

        jetty.getContainerRootContext().setErrorHandler(muteErrorHandler());

        return jetty;
    }

    @Bean
    protected InternalAccessFilter internalAccessFilter() {
        return new InternalAccessFilter(requestConfig.accessChecker());
    }

    @Bean
    protected VideoStreamingMuteErrorHandler muteErrorHandler() {
        return new VideoStreamingMuteErrorHandler(requestConfig.accessChecker());
    }
}
